﻿//////////////////////////////////////////////
// ImageEnvironmentEffectInfo.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkGraphics
{
	class Camera ;
	class Sampler ;
	class Texture ;
}

/// Includes ---------------------------------

// nkAstraeus
#include "ImageEnvironmentProjection.h"

/// Class ------------------------------------

namespace nkAstraeus
{
	struct ImageEnvironmentEffectInfo
	{
		// Texture to work with
		nkGraphics::Texture* _sourceTexture = nullptr ;
		// Sampler to use if required
		nkGraphics::Sampler* _sourceSampler = nullptr ;

		// Camera to force in case projection requires its data
		nkGraphics::Camera* _sourceCamera = nullptr ;

		// Projection to use for environment source
		IMAGE_ENVIRONMENT_PROJECTION _sourceProjection = IMAGE_ENVIRONMENT_PROJECTION::AUTO ;
	} ;
}